import { Payment } from './payment.entity';
import { OrderDetail } from './order-detail.entity';
import { User } from './user.entity';
export declare enum OrderStatus {
    PENDING = "pending",
    PROCESSING = "processing",
    SHIPPED = "shipped",
    DELIVERED = "delivered",
    CANCELLED = "cancelled",
    REFUNDED = "refunded"
}
export declare enum PaymentStatus {
    PAID = "paid",
    UNPAID = "unpaid",
    PARTIAL = "partial",
    CANCELLED = "cancelled"
}
export declare class Order {
    id: number;
    customerId: number;
    isGuest: boolean;
    customerType: string;
    paymentStatus: PaymentStatus;
    orderStatus: OrderStatus;
    paymentMethod: string;
    transactionRef: string;
    paymentBy: string;
    paymentNote: string;
    orderAmount: number;
    paidAmount: number;
    bringChangeAmount: number;
    bringChangeAmountCurrency: string;
    adminCommission: number;
    isPause: boolean;
    cause: string;
    shippingAddress: string;
    discountAmount: number;
    discountType: string;
    couponCode: string;
    couponDiscountBearer: string;
    shippingResponsibility: string;
    shippingMethodId: number;
    shippingCost: number;
    isShippingFree: boolean;
    orderGroupId: string;
    verificationCode: string;
    verificationStatus: boolean;
    sellerId: number;
    sellerIs: string;
    shippingAddressData: string;
    billingAddressData: string;
    deliveryManId: number;
    deliverymanCharge: number;
    expectedDeliveryDate: Date;
    orderNote: string;
    billingAddress: number;
    orderType: string;
    extraDiscount: number;
    extraDiscountType: string;
    freeDeliveryBearer: string;
    checked: boolean;
    shippingType: string;
    deliveryType: string;
    deliveryServiceName: string;
    thirdPartyDeliveryTrackingId: string;
    createdAt: Date;
    updatedAt: Date;
    customer: User;
    orderDetails: OrderDetail[];
    deliveryMan: User;
    payments: Payment[];
}
